; sse_string3_exp.asm
; porównywanie łańcuchów, długość jawna
extern printf
section .data					    
	string1	db	"the quick brown fox jumps over the "
			db	"lazy river" 
	string1Len equ $ - string1
	string2	db	"the quick brown fox jumps over the "
			db	"lazy river"
	string2Len equ $ - string2 
	dummy	db "confuse the world"       
	string3   db	"the quick brown fox jumps over the " 
			db	"lazy dog"     
	string3Len  equ $ - string3  
             
    fmt1       db "Łancuchy 1 i 2 są równe.",10,0
    fmt11      db "Łańcuchy 1 i 2 różnią się na pozycji %i.",10,0               
    fmt2       db "Łańcuchy 2 i 3 są równe.",10,0
    fmt22      db "Łańcuchy 2 i 3 różnią się na pozycji %i.",10,0   
 
section .bss
        buffer resb 64
section .text							
	global main					
main:
push	rbp
mov	rbp,rsp
  
; porównujemy łańcuchy 1 i 2
    mov 	rdi, string1
    mov 	rsi, string2
    mov 	rdx, string1Len
    mov 	rcx, string2Len
    call 	pstrcmp
	push    rbx
    push 	rax    ; odkładamy wynik na stos do późniejszego użytku

;wypisujemy łańcuchy 1 i 2 oraz wynik
;-------------------------------------------------------------
; najpierw budujemy łańcuch ze znakiem nowego wiersza i końcowym zerem
; string1
    mov 	rsi,string1
    mov 	rdi,buffer
    mov 	rcx,string1Len
    rep 	movsb        
    mov 	byte[rdi],10	; dodajemy znak nowego wiersza do bufora
    inc 	rdi         	; dodajemy końcowe zero do bufora
    mov 	byte[rdi],0
; wypisujemy
    mov 	rdi, buffer
    xor 	rax,rax
    call 	printf 
; string2
    mov 	rsi,string2
    mov 	rdi,buffer
    mov 	rcx,string2Len
    rep 	movsb        
    mov 	byte[rdi],10	; dodajemy znak nowego wiersza do bufora
    inc 	rdi         	; dodajemy końcowe zero do bufora
    mov 	byte[rdi],0
; wypisujemy
    mov 	rdi, buffer
    xor 	rax,rax
    call 	printf     
;-------------------------------------------------------------       
; teraz wypisujemy wynik porównania
	pop 	rax      ; przywracamy wartość zwrotną 
    pop     rbx
    mov 	rdi,fmt1
    cmp 	rax,0
    je 	eql1
    mov 	rdi,fmt11
 eql1:
    mov 	rsi, rax
    xor 	rax,rax
    call 	printf
;-------------------------------------------------------------
;-------------------------------------------------------------
; porównujemy łańcuchy 2 i 3
    mov 	rdi, string2
    mov 	rsi, string3
    mov 	rdx, string2Len
    mov 	rcx, string3Len
    call 	pstrcmp
	push    rbx
    push 	rax

; wypisujemy łańcuch 3 i wynik
;-------------------------------------------------------------
; najpierw budujemy łańcuch ze znakiem nowego wiersza i końcowym zerem
; string3
    mov 	rsi,string3
    mov 	rdi,buffer
    mov 	rcx,string3Len
    rep 	movsb        
    mov 	byte[rdi],10	; dodajemy znak nowego wiersza do bufora
    inc 	rdi         	; dodajemy końcowe zero do bufora
    mov 	byte[rdi],0
; wypisujemy
    mov 	rdi, buffer
    xor 	rax,rax
    call 	printf
;-------------------------------------------------------------       
; teraz wypisujemy wynik porównania
	pop 	rax     		; przywracamy wartość zwrotną
    pop     rbx
    mov 	rdi,fmt2
    cmp 	rax,0
    je 	eql2
    mov 	rdi,fmt22
 eql2:
    mov 	rsi, rax
    xor 	rax,rax
    call 	printf   

; wyjście
leave
ret
;-------------------------------------------------------------  

pstrcmp:
push	rbp		
mov	rbp,rsp
	xor     rbx, rbx
	mov     rax, rdx         ;rax zawiera długość pierwszego łańcucha
	mov     rdx, rcx         ;rdx zawiera długość drugiego łańcucha
	xor     rcx, rcx         ;rcx jako indeks
.loop:      
	movdqu   	xmm1, [rdi + rbx]
	pcmpestri	xmm1, [rsi + rbx], 0x18	; równy każdy | biegunowość ujemna
	jc      	.differ
	jz      	.equal
	add      	rbx, 16
	sub     	rax, 16
	sub      	rdx, 16
	jmp     	.loop

.differ:
    	mov 	rax,rbx         
    	add 	rax,rcx		; rcx zawiera różniącą się pozycję
    	inc 	rax         ; ponieważ liczenie zaczyna się od 0
    	jmp 	exit
.equal: 
    	xor 	rax,rax
exit:
leave
ret
